%
% Generate Figures 10.2-10.7 in the book:
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in
% Making Subjective Judgments, Wiley-IEEE Press, 2010.
%
% Dongrui WU (dongruiw@usc.edu), 4/19/2009
%

clc
close all
clear all
warning off all

%% Reviewer1's selection
X1=[3 5 4 5 4 3 4];
% Reviewer2's selection
X2=[3 4 5 4 4 4 5];
% Reviewer3's selection
X3=[4 5 5 5 5 5 4];
% Weights for the three measures of Tech Merit
WT=[3 2 1];
% Weights for the four measures of Presentation
WP=[2 1 2 1];
% Weights for the three reviewers
WR=[3 2 1];

%% Five word FOUs used by each of the seven measures
WordsM =[0   0    1.5  3.5  0   0    0.5  2.5 1; % Poor
    0.5 2.5  3.5  5.5  1.5 3    3    4.5 0.75; % Marginal
    2.5 4.5  5.5  7.5  3.5 5    5    6.5 0.75; % Adequate
    4.5 6.5  7.5  9.5  5.5 7    7    8.5 0.75; % Good
    6.5 8.5  10   10   7.5 9.5  10   10  1]; % Excellent

% Words corresponding to the weights for the three measures of Tech Merit
WordsT=[0 0 2 3.5 0 0 1 2.5 1;
    6.5 8 10 10 7.5 9 10 10 1
    2.5 4.5 5.5 7.5 3.5 5 5 6.5 .75];

% Words corresponding to the weights for the two measures of Presentation
WordsP=[[2.5 4.5 5.5 7.5 3.5 5 5 6.5]-2.5 .75;
    [2.5 4.5 5.5 7.5 3.5 5 5 6.5]+2.5 .75];

% Words corresponding to the weights for Tech Merit and Presentation
WordsTP=[[2.5 4.5 5.5 7.5 3.5 5 5 6.5]+2.5 .75;
    [2.5 4.5 5.5 7.5 3.5 5 5 6.5]-.5 .75];

% Words corresponding to the weights for the three reviewers
WordsR=[0     0     2.75  5.75   0     0     1.25  4.25 1; % low expertise
    1.25  4.25  5.75  8.75   2.75  5     5     7.25 0.75; %% moderate expertise
    4.25  7.25  10    10     5.75  8.75  10    10   1]; % high expertise

% words for decoding
WordsD=[0     0     3  4.5   0     0     2  3.5 1; % reject
    3 5 6 8  4 5.5 5.5  7 0.75; %% rewrite
    7 8 10 10 8 9 10 10  1]; % accept

%% Plot the five word FOUs
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
for i=1:5
    fill([WordsM(i,1:4) WordsM(i,8:-1:5)],[0 1 1 0 0 WordsM(i,9) WordsM(i,9) 0],[0.9 0.9 0.9]);
    hold on;
end
for i=1:5
    plot([WordsM(i,1:4) WordsM(i,8:-1:5)],[0 1 1 0 0 WordsM(i,9) WordsM(i,9) 0],'k-');
end
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'x');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
text(mean(WordsM(1,2:3))-.2,1.18,'Poor');
text(mean(WordsM(2,2:3))-.9,1.18,'Marginal');
text(mean(WordsM(3,2:3))-.8,1.18,'Adequate');
text(mean(WordsM(4,2:3))-.5,1.18,'Good');
text(mean(WordsM(5,2:3))-.8,1.18,'Excellent');
set(gca,'YTick',0:0.25:1);
set(gca,'XTick',0:1:10);
saveas(gcf,'Fig10-2.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
for i=1:3
    fill([WordsR(i,1:4) WordsR(i,8:-1:5)],[0 1 1 0 0 WordsR(i,9) WordsR(i,9) 0],[0.9 0.9 0.9]);
    hold on;
end
for i=1:3
    plot([WordsR(i,1:4) WordsR(i,8:-1:5)],[0 1 1 0 0 WordsR(i,9) WordsR(i,9) 0],'k-');
end
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'w');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
text(mean(WordsR(1,2:3))-.3,1.18,'Low');
text(mean(WordsR(2,2:3))-.8,1.18,'Moderate');
text(mean(WordsR(3,2:3))-.5,1.18,'High');
set(gca,'YTick',0:0.25:1);
set(gca,'XTick',0:1:10);
saveas(gcf,'Fig10-3.eps');

Xs=WordsM(X1(1:3),:);
Ws=WordsT(WT,:);

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
for i=1:3
    fill([Ws(i,1:4) Ws(i,8:-1:5)],[0 1 1 0 0 Ws(i,9) Ws(i,9) 0],[0.9 0.9 0.9]);
    hold on;
end
for i=1:3
    plot([Ws(i,1:4) Ws(i,8:-1:5)],[0 1 1 0 0 Ws(i,9) Ws(i,9) 0],'k-');
end
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'w');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
text('Interpreter','latex','String','$$\widetilde{W}_I$$','Position',[mean(Ws(1,2:3))-.3,1.18]);
text('Interpreter','latex','String','$$\widetilde{W}_{Co}$$','Position',[mean(Ws(2,2:3))-.5,1.18]);
text('Interpreter','latex','String','$$\widetilde{W}_D$$','Position',[mean(Ws(3,2:3))-.4,1.18]);
set(gca,'YTick',0:0.25:1);
set(gca,'XTick',0:1:10);
saveas(gcf,'Fig10-4.eps');

Xs=WordsM(X1(4:7),:);
Ws=WordsP(WP,:);

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
for i=1:4
    fill([Ws(i,1:4) Ws(i,8:-1:5)],[0 1 1 0 0 Ws(i,9) Ws(i,9) 0],[0.9 0.9 0.9]);
    hold on;
end
for i=1:4
    plot([Ws(i,1:4) Ws(i,8:-1:5)],[0 1 1 0 0 Ws(i,9) Ws(i,9) 0],'k-');
end
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'w');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
text('Interpreter','latex','String','$$\widetilde{W}_S=\widetilde{W}_{Cl}$$','Position',...
    [mean(Ws(1,2:3))-1,1.18]);
text('Interpreter','latex','String','$$\widetilde{W}_O=\widetilde{W}_R$$','Position',...
    [mean(Ws(2,2:3))-1,1.18]);
set(gca,'YTick',0:0.25:1);
set(gca,'XTick',0:1:10);
saveas(gcf,'Fig10-5.eps');

%% LWA for Reviewer 1: Overall %%%%%%%%%%%%%%%%%
Ws=WordsTP;

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
for i=1:2
    fill([Ws(i,1:4) Ws(i,8:-1:5)],[0 1 1 0 0 Ws(i,9) Ws(i,9) 0],[0.9 0.9 0.9]);
    hold on;
end
for i=1:2
    plot([Ws(i,1:4) Ws(i,8:-1:5)],[0 1 1 0 0 Ws(i,9) Ws(i,9) 0],'k-');
end
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'w');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
text('Interpreter','latex','String','$$\widetilde{W}_T$$','Position',...
    [mean(Ws(1,2:3))-.5,1.18]);
text('Interpreter','latex','String','$$\widetilde{W}_P$$','Position',...
    [mean(Ws(2,2:3))-.5,1.18]);
set(gca,'YTick',0:0.25:1);
set(gca,'XTick',0:1:10);
saveas(gcf,'Fig10-6.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
for i=1:3
    fill([WordsD(i,1:4) WordsD(i,8:-1:5)],[0 1 1 0 0 WordsD(i,9) WordsD(i,9) 0],[0.9 0.9 0.9]);
    hold on;
end
for i=1:3
    plot([WordsD(i,1:4) WordsD(i,8:-1:5)],[0 1 1 0 0 WordsD(i,9) WordsD(i,9) 0],'k-');
end
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'y');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
text(mean(WordsR(1,2:3))-.3,1.18,'Reject');
text(mean(WordsR(2,2:3))-.3,1.18,'Rewrite');
text(mean(WordsR(3,2:3))-.5,1.18,'Accept');
set(gca,'YTick',0:0.25:1);
set(gca,'XTick',0:1:10);
saveas(gcf,'Fig10-7.eps');

